using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

namespace Project7n {
    /// <summary>
    /// A Simple PCX-viewer for PCXClass.
    /// Example submitted by Endre I. Simay
    /// </summary>
public class WinForm1 : System.Windows.Forms.Form {
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;
        private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.TextBox textBox1;

        PCX_Reader PCX_reader= new PCX_Reader();
		private System.Windows.Forms.Label label1;

        public WinForm1() {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose (bool disposing) {
            if (disposing) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.panel1 = new System.Windows.Forms.Panel();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(8, 8);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(88, 23);
			this.button1.TabIndex = 0;
			this.button1.Text = "Open Picture";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// panel1
			// 
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.panel1.AutoScroll = true;
			this.panel1.Controls.Add(this.pictureBox1);
			this.panel1.Location = new System.Drawing.Point(8, 40);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(340, 236);
			this.panel1.TabIndex = 2;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new System.Drawing.Point(8, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "PCX|*.pcx";
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(240, 8);
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(104, 20);
			this.textBox1.TabIndex = 4;
			this.textBox1.Text = "";
			// 
			// label1
			// 
			this.label1.ImageAlign = System.Drawing.ContentAlignment.BottomCenter;
			this.label1.Location = new System.Drawing.Point(168, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 23);
			this.label1.TabIndex = 5;
			this.label1.Text = "Dimensions";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// WinForm1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(360, 286);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.button1);
			this.Name = "WinForm1";
			this.Text = "PCX Viewer";
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new WinForm1());
        }

        private void button1_Click(object sender, System.EventArgs e) {

            if (openFileDialog1.ShowDialog() == DialogResult.OK) {
                if (!open_and_view()) {
                    // a simple error-recording
                    if (PCX_reader.PCX_ErrorNumber() !=0)
                    {
                    MessageBox.Show(PCX_reader.PCX_ErrorString() + " Sorry", "PCXview Error",
                                    MessageBoxButtons.OK);
		    }else
                    {
                    MessageBox.Show("Problem with picture path or format." + " Sorry", "Pictureview Error",
                                    MessageBoxButtons.OK);
		    }
               }
            textBox1.Text= "H="+pictureBox1.Height.ToString()+"; W="+pictureBox1.Width.ToString();
            }
        }

        private bool open_and_view() {
            string fname;
			if ((fname = openFileDialog1.FileName)!= "") {
				try {
                    try {
                        if (pictureBox1.Image!= null) {
                            pictureBox1.Image.Dispose();
                        }
                        pictureBox1.Image = Image.FromStream(PCX_reader.FromFile(fname));
                    } catch (Exception) {
                        return false;
                    }
                    return true;
                } catch (Exception) {
                    return false;
                }
            } else {
                return false;
            }
        }

        }
    }



